/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.update;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.silverminer.shrines.Shrines;
import com.silverminer.shrines.config.ShrinesConfig;
import com.silverminer.shrines.generators.ShrinesBiomeTagsProvider;
import com.silverminer.shrines.random_variation.RandomVariationConfig;
import com.silverminer.shrines.registries.StructureRegistry;
import com.silverminer.shrines.structures.ShrinesConfiguration;
import com.silverminer.shrines.structures.ShrinesStructure;
import com.silverminer.shrines.structures.placement_types.RelativePlacementCalculator;
import com.silverminer.shrines.structures.spawn_criteria.GroundLevelDeltaSpawnCriteria;
import com.silverminer.shrines.structures.spawn_criteria.HeightSpawnCriteria;
import com.silverminer.shrines.structures.spawn_criteria.RandomChanceSpawnCriteria;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SDUpdate {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void updateStructureData(@NotNull Path oldNameSpacePath, @NotNull Path newNameSpacePath, String namespaceName) throws IOException {
        ArrayList disabledStructures = new ArrayList((Collection)ShrinesConfig.disabledStructures.get());
        RegistryAccess registryAccess = (RegistryAccess)RegistryAccess.f_123049_.get();
        Path structureDataPath = oldNameSpacePath.resolve("shrines_structures");
        Files.walk(structureDataPath, Integer.MAX_VALUE, new FileVisitOption[0]).map(structureDataItemPath -> {
            if (Files.isRegularFile(structureDataItemPath, new LinkOption[0])) {
                try {
                    String structureDataItemString = Files.readString(structureDataItemPath);
                    return StructureData.loadFromJSON(JsonParser.parseString((String)structureDataItemString));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }).filter(Objects::nonNull).map(structureData -> {
            SpawnConfiguration spawnConfiguration = structureData.getSpawnConfiguration();
            TagKey biomeTagKey = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(namespaceName, "has_structure/" + structureData.getKey().m_135815_()));
            Holder.Reference startPoolHolder = Holder.Reference.m_205766_((Registry)BuiltinRegistries.f_123864_, (ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122884_, (ResourceLocation)new ResourceLocation(spawnConfiguration.start_pool)));
            ConfiguredStructureFeature configuredStructureFeature = ((ShrinesStructure)((Object)((Object)StructureRegistry.SURFACE.get()))).m_209769_((FeatureConfiguration)new ShrinesConfiguration((Holder<StructureTemplatePool>)startPoolHolder, spawnConfiguration.jigsawMaxDepth(), List.of(new HeightSpawnCriteria(64, Integer.MAX_VALUE, 32), new RandomChanceSpawnCriteria(spawnConfiguration.spawn_chance()), new GroundLevelDeltaSpawnCriteria(2.0, 32)), new RelativePlacementCalculator(spawnConfiguration.height_offset())), biomeTagKey, spawnConfiguration.transformLand());
            ResourceKey configuredStructureFeatureResourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122882_, (ResourceLocation)new ResourceLocation(namespaceName, structureData.getKey().m_135815_()));
            StructureSet structureSet = new StructureSet((Holder)Holder.Reference.m_205766_((Registry)BuiltinRegistries.f_123862_, (ResourceKey)configuredStructureFeatureResourceKey), (StructurePlacement)new RandomSpreadStructurePlacement(spawnConfiguration.distance(), spawnConfiguration.separation(), RandomSpreadType.LINEAR, spawnConfiguration.seed_modifier()));
            ArrayList<Either> biomes = new ArrayList<Either>();
            if (spawnConfiguration.biome_blacklist().isEmpty()) {
                for (String biomeCategory : spawnConfiguration.biome_category_whitelist()) {
                    try {
                        switch (Biome.BiomeCategory.valueOf((String)biomeCategory)) {
                            case NONE: {
                                biomes.add(Either.left((Object)Biomes.f_48173_));
                                break;
                            }
                            case TAIGA: {
                                biomes.add(Either.right((Object)BiomeTags.f_207609_));
                                break;
                            }
                            case EXTREME_HILLS: {
                                biomes.add(Either.right((Object)BiomeTags.f_207608_));
                                break;
                            }
                            case JUNGLE: {
                                biomes.add(Either.right((Object)BiomeTags.f_207610_));
                                break;
                            }
                            case MESA: {
                                biomes.add(Either.right(ShrinesBiomeTagsProvider.IS_MESA));
                                break;
                            }
                            case PLAINS: {
                                biomes.add(Either.right(ShrinesBiomeTagsProvider.IS_PLAINS));
                                break;
                            }
                            case SAVANNA: {
                                biomes.add(Either.right(ShrinesBiomeTagsProvider.IS_SAVANNA));
                                break;
                            }
                            case ICY: {
                                biomes.add(Either.right(ShrinesBiomeTagsProvider.IS_ICY));
                                break;
                            }
                            case THEEND: {
                                biomes.add(Either.right(ShrinesBiomeTagsProvider.IS_THEEND));
                                break;
                            }
                            case BEACH: {
                                biomes.add(Either.right((Object)BiomeTags.f_207604_));
                                break;
                            }
                            case FOREST: {
                                biomes.add(Either.right((Object)BiomeTags.f_207611_));
                                break;
                            }
                            case OCEAN: {
                                biomes.add(Either.right((Object)BiomeTags.f_207603_));
                                break;
                            }
                            case DESERT: {
                                biomes.add(Either.right(ShrinesBiomeTagsProvider.IS_DESERT));
                                break;
                            }
                            case RIVER: {
                                biomes.add(Either.right((Object)BiomeTags.f_207605_));
                                break;
                            }
                            case SWAMP: {
                                biomes.add(Either.right(ShrinesBiomeTagsProvider.IS_SWAMP));
                                break;
                            }
                            case MUSHROOM: {
                                biomes.add(Either.right(ShrinesBiomeTagsProvider.IS_MUSHROOM));
                                break;
                            }
                            case NETHER: {
                                biomes.add(Either.right((Object)BiomeTags.f_207612_));
                                break;
                            }
                            case UNDERGROUND: {
                                biomes.add(Either.left((Object)Biomes.f_151785_));
                                biomes.add(Either.left((Object)Biomes.f_151784_));
                                break;
                            }
                            case MOUNTAIN: {
                                biomes.add(Either.right((Object)BiomeTags.f_207606_));
                            }
                        }
                    }
                    catch (NullPointerException e) {
                        Shrines.LOGGER.error("Skipped invalid Biome Category [{}]", (Object)biomeCategory);
                    }
                }
            } else {
                for (Map.Entry biomeEntry : ForgeRegistries.BIOMES.getEntries()) {
                    if (!spawnConfiguration.biome_category_whitelist().contains(Biome.m_204183_((Holder)Holder.m_205709_((Object)((Biome)biomeEntry.getValue()))).toString()) || spawnConfiguration.biome_blacklist().contains(((ResourceKey)biomeEntry.getKey()).m_135782_().toString())) continue;
                    biomes.add(Either.left((Object)((ResourceKey)biomeEntry.getKey())));
                }
            }
            if (!spawnConfiguration.generate() && !disabledStructures.contains(structureData.getKey().toString())) {
                disabledStructures.add(structureData.getKey().toString());
            }
            return new NewStructureData(structureData.getKey().m_135815_(), structureSet, configuredStructureFeature, biomes.stream().map(either -> {
                Either stringEither = either.mapBoth(ResourceKey::m_135782_, TagKey::f_203868_).mapBoth(Object::toString, Objects::toString).mapRight(string -> "#" + string);
                return stringEither.left().orElseGet(() -> stringEither.right().orElse(ShrinesBiomeTagsProvider.EMPTY.f_203868_().toString()));
            }).toList(), new RandomVariationConfig(List.of()));
        }).forEach(structureContainer -> {
            Path structureSetPath = newNameSpacePath.resolve("worldgen").resolve("structure_set").resolve(structureContainer.key + ".json");
            RegistryOps registryOps = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess);
            StructureSet.f_210001_.encode((Object)structureContainer.structureSet(), (DynamicOps)registryOps, (Object)new JsonObject()).resultOrPartial(arg_0 -> ((Logger)Shrines.LOGGER).error(arg_0)).ifPresent(jsonElement -> {
                try {
                    if (!Files.exists(structureSetPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(structureSetPath.getParent(), new FileAttribute[0]);
                    }
                    Files.writeString(structureSetPath, (CharSequence)GSON.toJson(jsonElement), new OpenOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            Path configuredStructureFeaturePath = newNameSpacePath.resolve("worldgen").resolve("configured_structure_feature").resolve(structureContainer.key() + ".json");
            ConfiguredStructureFeature.f_65400_.encode(structureContainer.configuredStructureFeature(), (DynamicOps)registryOps, (Object)new JsonObject()).resultOrPartial(arg_0 -> ((Logger)Shrines.LOGGER).error(arg_0)).ifPresent(jsonElement -> {
                try {
                    if (!Files.exists(configuredStructureFeaturePath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(configuredStructureFeaturePath.getParent(), new FileAttribute[0]);
                    }
                    Files.writeString(configuredStructureFeaturePath, (CharSequence)GSON.toJson(jsonElement), new OpenOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            Path randomVariationConfigPath = newNameSpacePath.resolve("shrines").resolve("random_variation").resolve("config").resolve(structureContainer.key() + ".json");
            RandomVariationConfig.DIRECT_CODEC.encode((Object)structureContainer.randomVariationConfig(), (DynamicOps)registryOps, (Object)new JsonObject()).resultOrPartial(arg_0 -> ((Logger)Shrines.LOGGER).error(arg_0)).ifPresent(jsonElement -> {
                try {
                    if (!Files.exists(randomVariationConfigPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(randomVariationConfigPath.getParent(), new FileAttribute[0]);
                    }
                    Files.writeString(randomVariationConfigPath, (CharSequence)GSON.toJson(jsonElement), new OpenOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            Path biomeTagPath = newNameSpacePath.resolve("tags").resolve("worldgen").resolve("biome").resolve("has_structure").resolve(structureContainer.key() + ".json");
            JsonObject tagFile = new JsonObject();
            tagFile.add("replace", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            JsonArray tagValues = new JsonArray();
            structureContainer.biomes().forEach(arg_0 -> ((JsonArray)tagValues).add(arg_0));
            tagFile.add("values", (JsonElement)tagValues);
            try {
                if (!Files.exists(biomeTagPath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(biomeTagPath.getParent(), new FileAttribute[0]);
                }
                Files.writeString(biomeTagPath, (CharSequence)GSON.toJson((JsonElement)tagFile), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        ShrinesConfig.disabledStructures.set(disabledStructures);
    }

    private record NewStructureData(String key, StructureSet structureSet, ConfiguredStructureFeature<?, ?> configuredStructureFeature, List<String> biomes, RandomVariationConfig randomVariationConfig) {
    }

    public static class StructureData
    implements Comparable<StructureData> {
        public static final Codec<StructureData> CODEC = RecordCodecBuilder.create(structureDataInstance -> structureDataInstance.group((App)Codec.STRING.fieldOf("name").forGetter(StructureData::getName), (App)ResourceLocation.f_135803_.fieldOf("key").forGetter(StructureData::getKey), (App)SpawnConfiguration.CODEC.fieldOf("spawn_configuration").forGetter(StructureData::getSpawnConfiguration), (App)ResourceLocation.f_135803_.optionalFieldOf("icon_path", null).forGetter(StructureData::getIconPath), (App)ResourceLocation.f_135803_.optionalFieldOf("novel", (Object)new ResourceLocation("")).forGetter(StructureData::getNovel), (App)Codec.either(VariationConfiguration.CODEC, NewVariationConfiguration.CODEC).optionalFieldOf("variation_configuration", (Object)Either.right((Object)new NewVariationConfiguration(false))).forGetter(structureData -> Either.right((Object)structureData.variationConfiguration))).apply((Applicative)structureDataInstance, StructureData::new));
        protected static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(StructureData.class);
        private final SpawnConfiguration spawnConfiguration;
        private final NewVariationConfiguration variationConfiguration;
        private final String name;
        private final ResourceLocation key;
        private final ResourceLocation novel;
        private final ResourceLocation iconPath;

        public StructureData(String name, ResourceLocation key, SpawnConfiguration spawnConfiguration, @Nullable ResourceLocation iconPath, @Nullable ResourceLocation novel, Either<VariationConfiguration, NewVariationConfiguration> variationConfiguration) {
            this.name = name;
            this.key = key;
            this.novel = Objects.requireNonNullElse(novel, key);
            this.iconPath = Objects.requireNonNullElse(iconPath, key);
            this.spawnConfiguration = spawnConfiguration;
            this.variationConfiguration = variationConfiguration.right().orElse(variationConfiguration.left().map(VariationConfiguration::toNewConfiguration).orElse(new NewVariationConfiguration(false, new ArrayList<String>(), new ArrayList<String>())));
        }

        @Nullable
        public static StructureData loadFromJSON(JsonElement tag) {
            DataResult dataResult = CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)tag);
            Optional optional = dataResult.resultOrPartial(arg_0 -> ((org.apache.logging.log4j.Logger)LOGGER).error(arg_0));
            return optional.map(Pair::getFirst).orElse(null);
        }

        public NewVariationConfiguration getVariationConfiguration() {
            return this.variationConfiguration;
        }

        public ResourceLocation getKey() {
            return this.key;
        }

        public SpawnConfiguration getSpawnConfiguration() {
            return this.spawnConfiguration;
        }

        public ResourceLocation getNovel() {
            return this.novel;
        }

        public ResourceLocation getIconPath() {
            return this.iconPath;
        }

        @Override
        public int compareTo(StructureData o) {
            return this.getName().compareTo(o.getName());
        }

        public String getName() {
            return this.name;
        }
    }

    public record SpawnConfiguration(boolean transformLand, boolean generate, double spawn_chance, int distance, int separation, int seed_modifier, int height_offset, List<String> biome_blacklist, List<String> biome_category_whitelist, List<String> dimension_whitelist, String start_pool, int jigsawMaxDepth) {
        public static final Codec<SpawnConfiguration> CODEC = RecordCodecBuilder.create(structureDataInstance -> structureDataInstance.group((App)Codec.BOOL.optionalFieldOf("transform_land", (Object)true).forGetter(SpawnConfiguration::transformLand), (App)Codec.BOOL.optionalFieldOf("generate", (Object)true).forGetter(SpawnConfiguration::generate), (App)Codec.DOUBLE.fieldOf("spawn_chance").forGetter(SpawnConfiguration::spawn_chance), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("distance").forGetter(SpawnConfiguration::distance), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("separation").forGetter(SpawnConfiguration::separation), (App)Codec.INT.fieldOf("seed_modifier").forGetter(SpawnConfiguration::seed_modifier), (App)Codec.INT.optionalFieldOf("height_offset", (Object)0).forGetter(SpawnConfiguration::height_offset), (App)Codec.list((Codec)Codec.STRING).fieldOf("biome_blacklist").forGetter(SpawnConfiguration::biome_blacklist), (App)Codec.list((Codec)Codec.STRING).fieldOf("biome_category_whitelist").forGetter(SpawnConfiguration::biome_category_whitelist), (App)Codec.list((Codec)Codec.STRING).fieldOf("dimension_whitelist").forGetter(SpawnConfiguration::dimension_whitelist), (App)Codec.STRING.fieldOf("start_pool").forGetter(SpawnConfiguration::start_pool), (App)Codec.INT.optionalFieldOf("jigsaw_max_depth", (Object)7).forGetter(SpawnConfiguration::jigsawMaxDepth)).apply((Applicative)structureDataInstance, SpawnConfiguration::new));
    }

    public record VariationConfiguration(boolean isEnabled, SimpleVariationConfiguration simpleVariationConfiguration, NestedVariationConfiguration nestedVariationConfiguration) {
        public static final Codec<VariationConfiguration> CODEC = RecordCodecBuilder.create(variationConfigurationInstance -> variationConfigurationInstance.group((App)Codec.BOOL.fieldOf("is_enabled").forGetter(VariationConfiguration::isEnabled), (App)SimpleVariationConfiguration.CODEC.optionalFieldOf("simple", (Object)SimpleVariationConfiguration.ALL_DISABLED).forGetter(VariationConfiguration::simpleVariationConfiguration), (App)NestedVariationConfiguration.CODEC.optionalFieldOf("nested", (Object)NestedVariationConfiguration.ALL_DISABLED).forGetter(VariationConfiguration::nestedVariationConfiguration)).apply((Applicative)variationConfigurationInstance, VariationConfiguration::new));

        @Contract(value=" -> new")
        @NotNull
        public NewVariationConfiguration toNewConfiguration() {
            Pair<List<String>, List<String>> pairDisabledMaterialsTypes = this.simpleVariationConfiguration().getDisabledMaterials();
            List<String> disabledTypes = this.nestedVariationConfiguration().getDisabledTypes();
            disabledTypes.addAll((Collection)pairDisabledMaterialsTypes.getSecond());
            return new NewVariationConfiguration(this.isEnabled(), (List)pairDisabledMaterialsTypes.getFirst(), disabledTypes);
        }

        public record SimpleVariationConfiguration(boolean isWoolEnabled, boolean isTerracottaEnabled, boolean isGlazedTerracottaEnabled, boolean isConcreteEnabled, boolean isConcretePowderEnabled, boolean arePlanksEnabled, boolean areOresEnabled, boolean areStonesEnabled, boolean areBeesEnabled) {
            public static final Codec<SimpleVariationConfiguration> CODEC = RecordCodecBuilder.create(variationConfigurationInstance -> variationConfigurationInstance.group((App)Codec.BOOL.fieldOf("is_wool_enabled").forGetter(SimpleVariationConfiguration::isWoolEnabled), (App)Codec.BOOL.fieldOf("is_terracotta_enabled").forGetter(SimpleVariationConfiguration::isTerracottaEnabled), (App)Codec.BOOL.fieldOf("is_glazed_terracotta").forGetter(SimpleVariationConfiguration::isGlazedTerracottaEnabled), (App)Codec.BOOL.fieldOf("is_concrete_enabled").forGetter(SimpleVariationConfiguration::isConcreteEnabled), (App)Codec.BOOL.fieldOf("is_concrete_powder_enabled").forGetter(SimpleVariationConfiguration::isConcretePowderEnabled), (App)Codec.BOOL.fieldOf("are_planks_enabled").forGetter(SimpleVariationConfiguration::arePlanksEnabled), (App)Codec.BOOL.fieldOf("are_ores_enabled").forGetter(SimpleVariationConfiguration::areOresEnabled), (App)Codec.BOOL.fieldOf("are_stones_enabled").forGetter(SimpleVariationConfiguration::areStonesEnabled), (App)Codec.BOOL.fieldOf("are_bees_enabled").forGetter(SimpleVariationConfiguration::areBeesEnabled)).apply((Applicative)variationConfigurationInstance, SimpleVariationConfiguration::new));
            public static final SimpleVariationConfiguration ALL_DISABLED = new SimpleVariationConfiguration(false, false, false, false, false, false, false, false, false);

            @NotNull
            public Pair<List<String>, List<String>> getDisabledMaterials() {
                ArrayList<String> disabledMaterials = new ArrayList<String>();
                ArrayList<String> disabledTypes = new ArrayList<String>();
                if (!this.isWoolEnabled()) {
                    disabledTypes.add("wool");
                }
                if (!this.isTerracottaEnabled()) {
                    disabledTypes.add("terracotta");
                }
                if (!this.isGlazedTerracottaEnabled()) {
                    disabledTypes.add("glazed_terracotta");
                }
                if (!this.isConcreteEnabled()) {
                    disabledTypes.add("concrete");
                }
                if (!this.isConcretePowderEnabled()) {
                    disabledTypes.add("concrete_powder");
                }
                if (!this.arePlanksEnabled()) {
                    disabledTypes.add("planks");
                }
                if (!this.areOresEnabled()) {
                    disabledMaterials.add("ores");
                }
                if (!this.areStonesEnabled()) {
                    disabledMaterials.add("stone");
                }
                if (!this.areBeesEnabled()) {
                    disabledMaterials.add("bees");
                }
                return Pair.of(disabledMaterials, disabledTypes);
            }
        }

        public record NestedVariationConfiguration(boolean areSlabsEnabled, boolean isButtonEnabled, boolean isFenceEnabled, boolean areNormalLogsEnabled, boolean areStrippedLogsEnabled, boolean areTrapdoorsEnabled, boolean areDoorsEnabled, boolean isStairEnabled, boolean isStandingSignEnabled, boolean isWallSignEnabled) {
            public static final Codec<NestedVariationConfiguration> CODEC = RecordCodecBuilder.create(variationConfigurationInstance -> variationConfigurationInstance.group((App)Codec.BOOL.fieldOf("are_slabs_enabled").forGetter(NestedVariationConfiguration::areSlabsEnabled), (App)Codec.BOOL.fieldOf("is_button_enabled").forGetter(NestedVariationConfiguration::isButtonEnabled), (App)Codec.BOOL.fieldOf("is_fence_enabled").forGetter(NestedVariationConfiguration::isFenceEnabled), (App)Codec.BOOL.fieldOf("are_normal_logs_enabled").forGetter(NestedVariationConfiguration::areNormalLogsEnabled), (App)Codec.BOOL.fieldOf("are_stripped_logs_enabled").forGetter(NestedVariationConfiguration::areStrippedLogsEnabled), (App)Codec.BOOL.fieldOf("are_trapdoors_enabled").forGetter(NestedVariationConfiguration::areTrapdoorsEnabled), (App)Codec.BOOL.fieldOf("are_doors_enabled").forGetter(NestedVariationConfiguration::areDoorsEnabled), (App)Codec.BOOL.fieldOf("is_stair_enabled").forGetter(NestedVariationConfiguration::isStairEnabled), (App)Codec.BOOL.fieldOf("is_standing_sign_enabled").forGetter(NestedVariationConfiguration::isStandingSignEnabled), (App)Codec.BOOL.fieldOf("is_wall_sign_enabled").forGetter(NestedVariationConfiguration::isWallSignEnabled)).apply((Applicative)variationConfigurationInstance, NestedVariationConfiguration::new));
            public static final NestedVariationConfiguration ALL_DISABLED = new NestedVariationConfiguration(false, false, false, false, false, false, false, false, false, false);

            @NotNull
            public List<String> getDisabledTypes() {
                ArrayList<String> disabledTypes = new ArrayList<String>();
                if (this.areSlabsEnabled()) {
                    disabledTypes.add("slab");
                }
                if (this.isButtonEnabled()) {
                    disabledTypes.add("button");
                }
                if (this.isFenceEnabled()) {
                    disabledTypes.add("fence");
                }
                if (this.areNormalLogsEnabled()) {
                    disabledTypes.add("log");
                }
                if (this.areStrippedLogsEnabled()) {
                    disabledTypes.add("stripped_log");
                }
                if (this.areTrapdoorsEnabled()) {
                    disabledTypes.add("trapdoor");
                }
                if (this.areDoorsEnabled()) {
                    disabledTypes.add("door");
                }
                if (this.isStairEnabled()) {
                    disabledTypes.add("stair");
                }
                if (this.isStandingSignEnabled()) {
                    disabledTypes.add("standing_sign");
                }
                if (this.isWallSignEnabled()) {
                    disabledTypes.add("wall_sign");
                }
                return disabledTypes;
            }
        }
    }

    public static class NewVariationConfiguration {
        public static final Codec<NewVariationConfiguration> CODEC = RecordCodecBuilder.create(newVariationConfigurationInstance -> newVariationConfigurationInstance.group((App)Codec.BOOL.fieldOf("active").forGetter(NewVariationConfiguration::isEnabled), (App)Codec.list((Codec)Codec.STRING).fieldOf("disabled_materials").forGetter(NewVariationConfiguration::getDisabledMaterials), (App)Codec.list((Codec)Codec.STRING).fieldOf("disabled_types").forGetter(NewVariationConfiguration::getDisabledTypes)).apply((Applicative)newVariationConfigurationInstance, NewVariationConfiguration::new));
        private final boolean isEnabled;
        private final List<String> disabledMaterials;
        private final List<String> disabledTypes;

        public NewVariationConfiguration(boolean isEnabled) {
            this(isEnabled, new ArrayList<String>(), new ArrayList<String>());
        }

        public NewVariationConfiguration(boolean isEnabled, List<String> disabledMaterials, List<String> disabledTypes) {
            this.isEnabled = isEnabled;
            this.disabledMaterials = ImmutableList.copyOf(disabledMaterials);
            this.disabledTypes = ImmutableList.copyOf(disabledTypes);
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public List<String> getDisabledMaterials() {
            return this.disabledMaterials;
        }

        public List<String> getDisabledTypes() {
            return this.disabledTypes;
        }
    }
}

